using System;

using System.Data;

using Borland.Data.Common;
using Borland.Data.Provider;

namespace DataReader
{

	class SimpleDataReaderDemo
	{

		[STAThread]
		static void Main(string[] args)
		{

			String s_table;

			if( args.Length > 0 )
				s_table = args[0];
			else
				s_table = "EMPLOYEE";

			// Create the connection string and BdpConnection
			String s_conn =
				"assembly=Borland.Data.Interbase,Version=2.5.0.0,Culture=" +
				"neutral,PublicKeyToken=91d62ebb5b0d1b1b;vendorclient=" +
				"gds32.dll;database=localhost:C:\\Borland\\InterBase\\" +
				"examples\\database\\employee.gdb;provider=Interbase;username" +
				"=sysdba;password=masterkey";
			BdpConnection bdp_conn = new BdpConnection( s_conn );

			BdpCommand bdp_comm = new BdpCommand("select * from " + s_table, bdp_conn);

			bdp_conn.Open();
			BdpDataReader bdp_dr = bdp_comm.ExecuteReader();

			while( bdp_dr.Read() )
				GetData( bdp_dr );
            
		}

		public static void GetData( IDataReader i_reader ){

			try
			{

				for (int index = 0; index < i_reader.FieldCount; index++)
				{

					if ( i_reader.IsDBNull(index) )
						Console.Write("NULL");
					else
					{

						Type t =  i_reader.GetFieldType(index);
						if (t == typeof(Int16) )
							Console.Write(i_reader.GetInt16(index));
						else if ( t == typeof(Int32) )
							Console.Write(i_reader.GetInt32(index));
						else if ( t == typeof(String) )
							Console.Write(i_reader.GetString(index));
						else if ( t == typeof(float) )
							Console.Write(i_reader.GetFloat(index));
						else if ( t == typeof(double) )
							Console.Write(i_reader.GetDouble(index));
						else if ( t == typeof(DateTime) )
							Console.Write(i_reader.GetDateTime(index));
						else if ( t == typeof(Decimal) )
							Console.Write(i_reader.GetDecimal(index));
						else if ( t == typeof(Byte[]) )
						{

							int buffSize = (int)i_reader.GetBytes(index, 0, null, 0, 0);
							byte[] buffer = new byte[buffSize];

							if ( i_reader.GetBytes(index, 0, buffer, 0, buffSize) != 0 )
								Console.Write( "Blob Data: " + buffer.Length + " bytes");

						}
						else if ( t == typeof(char[]) )
						{
							int buffSize = (int)i_reader.GetChars(index, 0, null, 0, 0);
							char[] charbuf = new char[buffSize];

							if ( i_reader.GetChars(index, 0, charbuf, 0, buffSize) != 0 )
								Console.Write("Clob Data: " + charbuf.Length + " chars");
						}
						else
						{
							Console.Write("Unknown DataType");
						}

					}

					if (index < i_reader.FieldCount -1 && index >= 0)
						Console.Write(", ");

				}
			}
			catch( Borland.Data.Common.BdpException e )
			{
				Console.Write("BdpException caught:" + e.Message);
				return;
			}
			catch( Exception e)
			{
				Console.Write("Exception caught:" + e.Message);
				return;
			}

			Console.WriteLine();

		}

	}
}
